/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.curseofpandora.content.sets.angle;

import dev.xkmc.curseofpandora.content.complex.BaseTickingToken;
import dev.xkmc.curseofpandora.content.complex.IAttackListenerToken;
import dev.xkmc.curseofpandora.content.complex.ITokenProviderItem;
import dev.xkmc.curseofpandora.content.sets.angle.AngelicPunishment;
import dev.xkmc.curseofpandora.event.ClientSpellText;
import dev.xkmc.curseofpandora.init.data.CoPConfig;
import dev.xkmc.curseofpandora.init.data.CoPLangData;
import dev.xkmc.curseofpandora.init.registrate.CoPAttrs;
import dev.xkmc.l2damagetracker.contents.attack.AttackCache;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import org.jetbrains.annotations.Nullable;

public class AngelicWing
extends ITokenProviderItem<Data> {
    private static int getIndexReq() {
        return (Integer)CoPConfig.COMMON.angelic.angelicWingRealityIndex.get();
    }

    public AngelicWing(Item.Properties properties) {
        super(properties, Data::new);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        list.add((Component)CoPLangData.Angelic.CHECK.get(new Object[0]).m_130940_(ChatFormatting.GRAY));
        boolean pass = ClientSpellText.getReality(level) >= AngelicWing.getIndexReq();
        list.add((Component)CoPLangData.IDS.REALITY_INDEX.get(AngelicWing.getIndexReq()).m_130940_(pass ? ChatFormatting.YELLOW : ChatFormatting.GRAY));
        list.add((Component)Component.m_237113_((String)"- ").m_7220_((Component)CoPLangData.Angelic.WING_IMMUNE.get(new Object[0])).m_130940_(pass ? ChatFormatting.DARK_AQUA : ChatFormatting.DARK_GRAY));
        list.add((Component)Component.m_237113_((String)"- ").m_7220_((Component)CoPLangData.Angelic.WING.get(new Object[0])).m_130940_(pass ? ChatFormatting.DARK_AQUA : ChatFormatting.DARK_GRAY));
    }

    @Override
    public void tick(Player player) {
        if (player.m_21133_((Attribute)CoPAttrs.REALITY.get()) >= (double)AngelicWing.getIndexReq()) {
            super.tick(player);
        }
    }

    @SerialClass
    public static class Data
    extends BaseTickingToken
    implements IAttackListenerToken {
        @Override
        protected void removeImpl(Player player) {
        }

        private boolean check(Player player) {
            return AngelicPunishment.check(player, AngelicWing.getIndexReq());
        }

        @Override
        public void onPlayerAttacked(Player player, AttackCache cache) {
            if (!this.check(player)) {
                return;
            }
            LivingAttackEvent event = cache.getLivingAttackEvent();
            assert (event != null);
            if (event.getSource().m_276093_(DamageTypes.f_268576_)) {
                event.setCanceled(true);
            }
            if (event.getSource().m_276093_(DamageTypes.f_268671_)) {
                event.setCanceled(true);
            }
        }

        @Override
        protected void tickImpl(Player player) {
            Vec3 vec;
            double len;
            if (!this.check(player)) {
                return;
            }
            double boost = (Double)CoPConfig.COMMON.angelic.angelicWingBoost.get();
            double max = (Double)CoPConfig.COMMON.angelic.angelicWingMaxSpeed.get();
            int req = AngelicWing.getIndexReq();
            if (player.m_21133_((Attribute)CoPAttrs.REALITY.get()) < (double)req) {
                return;
            }
            if (player.m_21255_() && (len = (vec = player.m_20184_()).m_82553_()) < max && len > 0.2) {
                player.m_20256_(vec.m_82490_(1.0 + boost / len));
            }
        }
    }
}

